class StatisticMut extends Mutator config(xSetup_statistics);

var string 		gamestyle,
				MapName;

struct PlayerStats
{
var string 		Player;
var int 		DMscore,
				DMdeaths,
				TDMscore,
				TDMdeaths,
				CTFscore,
				CTFdeaths,
				DOMscore,
				DOMdeaths;
};

struct MapStats
{
var string		MapTitle,
				Prefix;
var int			NumPlays;
};

var PlayerStats db[32];
var config PlayerStats 	data[10000],
						tempDM[10],
						tempTDM[10],
						tempCTF[10],
						tempDOM[10];
var config String	 	topDM[10],
						topTDM[10],
						topCTF[10],
						topDOM[10];
var config MapStats		Maps[500],
						tempMaps[10];
var config String	 	topMaps[10];
						
var config int c;	//this variable is used to cycle through the player databases
var config int d;	//this variable is used to cycle through the map databases
var int countdown, TimeBetweenStatAssign;
var bool MapAssignedToDB;

function PreBeginPlay ()
{
	Super.PreBeginPlay();
	
	SetTimer(1.0,True);
	
	switch (Level.Game.Default.GameName)
		{
		case "Tournament DeathMatch":
			gamestyle = "DM";
			break;
		case "Tournament Team Game":
			gamestyle = "TDM";
			break;
		case "Capture the Flag":
			gamestyle = "CTF";
			break;
		case "Domination":
			gamestyle = "DOM";
			break;
		default:
		return;
		}
	//log ("xSetup statistic module has loaded and found the gamestyle to be:"@gamestyle);
}

function CycleMapDatabase()
{
	//check for map #1
	if ( Maps[d].NumPlays >= tempMaps[0].NumPlays )
		{
		tempMaps[0].MapTitle = Maps[d].MapTitle;
		tempMaps[0].NumPlays = Maps[d].NumPlays;
		topMaps[0] = "1. "$Maps[d].MapTitle$" ("$Maps[d].NumPlays$")";
		}
	//check for map #2
	else if ( Maps[d].NumPlays >= tempMaps[1].NumPlays && Maps[d].MapTitle != tempMaps[0].MapTitle)
		{
		tempMaps[1].MapTitle = Maps[d].MapTitle;
		tempMaps[1].NumPlays = Maps[d].NumPlays;
		topMaps[1] = "2. "$Maps[d].MapTitle$" ("$Maps[d].NumPlays$")";
		}
	//check for map #3
	else if ( Maps[d].NumPlays >= tempMaps[2].NumPlays && Maps[d].MapTitle != tempMaps[0].MapTitle && Maps[d].MapTitle != tempMaps[1].MapTitle)
		{
		tempMaps[2].MapTitle = Maps[d].MapTitle;
		tempMaps[2].NumPlays = Maps[d].NumPlays;
		topMaps[2] = "3. "$Maps[d].MapTitle$" ("$Maps[d].NumPlays$")";
		}
	//check for map #4
	else if ( Maps[d].NumPlays >= tempMaps[3].NumPlays && Maps[d].MapTitle != tempMaps[0].MapTitle && Maps[d].MapTitle != tempMaps[1].MapTitle && Maps[d].MapTitle != tempMaps[2].MapTitle)
		{
		tempMaps[3].MapTitle = Maps[d].MapTitle;
		tempMaps[3].NumPlays = Maps[d].NumPlays;
		topMaps[3] = "4. "$Maps[d].MapTitle$" ("$Maps[d].NumPlays$")";
		}
	//check for map #5
	else if ( Maps[d].NumPlays >= tempMaps[4].NumPlays && Maps[d].MapTitle != tempMaps[0].MapTitle && Maps[d].MapTitle != tempMaps[1].MapTitle && Maps[d].MapTitle != tempMaps[2].MapTitle && Maps[d].MapTitle != tempMaps[3].MapTitle)
		{
		tempMaps[4].MapTitle = Maps[d].MapTitle;
		tempMaps[4].NumPlays = Maps[d].NumPlays;
		topMaps[4] = "5. "$Maps[d].MapTitle$" ("$Maps[d].NumPlays$")";
		}
	//check for map #6
	else if ( Maps[d].NumPlays >= tempMaps[5].NumPlays && Maps[d].MapTitle != tempMaps[0].MapTitle && Maps[d].MapTitle != tempMaps[1].MapTitle && Maps[d].MapTitle != tempMaps[2].MapTitle && Maps[d].MapTitle != tempMaps[3].MapTitle && Maps[d].MapTitle != tempMaps[4].MapTitle)
		{
		tempMaps[5].MapTitle = Maps[d].MapTitle;
		tempMaps[5].NumPlays = Maps[d].NumPlays;
		topMaps[5] = "6. "$Maps[d].MapTitle$" ("$Maps[d].NumPlays$")";
		}
	//check for map #7
	else if ( Maps[d].NumPlays >= tempMaps[6].NumPlays && Maps[d].MapTitle != tempMaps[0].MapTitle && Maps[d].MapTitle != tempMaps[1].MapTitle && Maps[d].MapTitle != tempMaps[2].MapTitle && Maps[d].MapTitle != tempMaps[3].MapTitle && Maps[d].MapTitle != tempMaps[4].MapTitle && Maps[d].MapTitle != tempMaps[5].MapTitle)
		{
		tempMaps[6].MapTitle = Maps[d].MapTitle;
		tempMaps[6].NumPlays = Maps[d].NumPlays;
		topMaps[6] = "7. "$Maps[d].MapTitle$" ("$Maps[d].NumPlays$")";
		}
	//check for map #8
	else if ( Maps[d].NumPlays >= tempMaps[7].NumPlays && Maps[d].MapTitle != tempMaps[0].MapTitle && Maps[d].MapTitle != tempMaps[1].MapTitle && Maps[d].MapTitle != tempMaps[2].MapTitle && Maps[d].MapTitle != tempMaps[3].MapTitle && Maps[d].MapTitle != tempMaps[4].MapTitle && Maps[d].MapTitle != tempMaps[5].MapTitle && Maps[d].MapTitle != tempMaps[6].MapTitle)
		{
		tempMaps[7].MapTitle = Maps[d].MapTitle;
		tempMaps[7].NumPlays = Maps[d].NumPlays;
		topMaps[7] = "8. "$Maps[d].MapTitle$" ("$Maps[d].NumPlays$")";
		}
	//check for map #9
	else if ( Maps[d].NumPlays >= tempMaps[8].NumPlays && Maps[d].MapTitle != tempMaps[0].MapTitle && Maps[d].MapTitle != tempMaps[1].MapTitle && Maps[d].MapTitle != tempMaps[2].MapTitle && Maps[d].MapTitle != tempMaps[3].MapTitle && Maps[d].MapTitle != tempMaps[4].MapTitle && Maps[d].MapTitle != tempMaps[5].MapTitle && Maps[d].MapTitle != tempMaps[6].MapTitle && Maps[d].MapTitle != tempMaps[7].MapTitle)
		{
		tempMaps[8].MapTitle = Maps[d].MapTitle;
		tempMaps[8].NumPlays = Maps[d].NumPlays;
		topMaps[8] = "9. "$Maps[d].MapTitle$" ("$Maps[d].NumPlays$")";
		}
	//check for map #10
	else if ( Maps[d].NumPlays >= tempMaps[9].NumPlays && Maps[d].MapTitle != tempMaps[0].MapTitle && Maps[d].MapTitle != tempMaps[1].MapTitle && Maps[d].MapTitle != tempMaps[2].MapTitle && Maps[d].MapTitle != tempMaps[3].MapTitle && Maps[d].MapTitle != tempMaps[4].MapTitle && Maps[d].MapTitle != tempMaps[5].MapTitle && Maps[d].MapTitle != tempMaps[6].MapTitle && Maps[d].MapTitle != tempMaps[7].MapTitle && Maps[d].MapTitle != tempMaps[8].MapTitle)
		{
		tempMaps[9].MapTitle = Maps[d].MapTitle;
		tempMaps[9].NumPlays = Maps[d].NumPlays;
		topMaps[9] = "10. "$Maps[d].MapTitle$" ("$Maps[d].NumPlays$")";
		}
}

function AddMapToDatabase()
{
local int i;

	MapName = Level.GetURLMap(); // returns e.g. DM-Deck16][.unr
	MapName = Left(MapName, InStr(MapName, "."));
	//log ("xSetup - Mapname is: "$MapName);

	for (i=0;i<500;i++)
		{
		if ( Maps[i].MapTitle == MapName || Maps[i].MapTitle == "" )
			{
			Maps[i].MapTitle = MapName;
			Maps[i].Prefix = gamestyle;
			Maps[i].NumPlays++;
			i = 10000;
			}
		}
	MapAssignedToDB = True;
}

simulated function Tick(float DT) 
{
	Super.Tick(DT);
	
	if ( TimeBetweenStatAssign > 1 )
		{
		CycleDM();
		CycleTDM();
		CycleCTF();
		CycleDOM();
		CycleMapDatabase();
		}
	
	c++;
	if ( data[c].Player == "" || c > 9999 )
		c = 0;

	d++;
	if ( Maps[d].MapTitle == "" || d > 499 )
		d = 0;
}

//This function cycles through the DM database and assign top 10 players
function CycleDM()
{
local float Eff, s, d;

	//check for DM #1
	if ( data[c].DMscore >= tempDM[0].DMscore )
		{
		tempDM[0].Player = data[c].Player;
		tempDM[0].DMscore = data[c].DMscore;
		tempDM[0].DMdeaths = data[c].DMdeaths;
		s = data[c].DMscore;
		d = data[c].DMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDM[0] = data[c].Player$" - "$string(data[c].DMscore)$" - "$data[c].DMdeaths$" - "$int(Eff)$"%";
		}
	//check for DM #2
	else if ( data[c].DMscore >= tempDM[1].DMscore && data[c].Player != tempDM[0].Player )
		{
		tempDM[1].Player = data[c].Player;
		tempDM[1].DMscore = data[c].DMscore;
		tempDM[1].DMdeaths = data[c].DMdeaths;
		s = data[c].DMscore;
		d = data[c].DMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDM[1] = data[c].Player$" - "$string(data[c].DMscore)$" - "$data[c].DMdeaths$" - "$int(Eff)$"%";
		}
	//check for DM #3
	else if ( data[c].DMscore >= tempDM[2].DMscore && data[c].Player != tempDM[0].Player && data[c].Player != tempDM[1].Player)
		{
		tempDM[2].Player = data[c].Player;
		tempDM[2].DMscore = data[c].DMscore;
		tempDM[2].DMdeaths = data[c].DMdeaths;
		s = data[c].DMscore;
		d = data[c].DMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDM[2] = data[c].Player$" - "$string(data[c].DMscore)$" - "$data[c].DMdeaths$" - "$int(Eff)$"%";
		}
	//check for DM #4
	else if ( data[c].DMscore >= tempDM[3].DMscore && data[c].Player != tempDM[0].Player && data[c].Player != tempDM[1].Player && data[c].Player != tempDM[2].Player)
		{
		tempDM[3].Player = data[c].Player;
		tempDM[3].DMscore = data[c].DMscore;
		tempDM[3].DMdeaths = data[c].DMdeaths;
		s = data[c].DMscore;
		d = data[c].DMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDM[3] = data[c].Player$" - "$string(data[c].DMscore)$" - "$data[c].DMdeaths$" - "$int(Eff)$"%";
		}
	//check for DM #5
	else if ( data[c].DMscore >= tempDM[4].DMscore && data[c].Player != tempDM[0].Player && data[c].Player != tempDM[1].Player && data[c].Player != tempDM[2].Player && data[c].Player != tempDM[3].Player)
		{
		tempDM[4].Player = data[c].Player;
		tempDM[4].DMscore = data[c].DMscore;
		tempDM[4].DMdeaths = data[c].DMdeaths;
		s = data[c].DMscore;
		d = data[c].DMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDM[4] = data[c].Player$" - "$string(data[c].DMscore)$" - "$data[c].DMdeaths$" - "$int(Eff)$"%";
		}	
	//check for DM #6
	else if ( data[c].DMscore >= tempDM[5].DMscore && data[c].Player != tempDM[0].Player && data[c].Player != tempDM[1].Player && data[c].Player != tempDM[2].Player && data[c].Player != tempDM[3].Player && data[c].Player != tempDM[4].Player)
		{
		tempDM[5].Player = data[c].Player;
		tempDM[5].DMscore = data[c].DMscore;
		tempDM[5].DMdeaths = data[c].DMdeaths;
		s = data[c].DMscore;
		d = data[c].DMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDM[5] = data[c].Player$" - "$string(data[c].DMscore)$" - "$data[c].DMdeaths$" - "$int(Eff)$"%";
		}	
	//check for DM #7
	else if ( data[c].DMscore >= tempDM[6].DMscore && data[c].Player != tempDM[0].Player && data[c].Player != tempDM[1].Player && data[c].Player != tempDM[2].Player && data[c].Player != tempDM[3].Player && data[c].Player != tempDM[4].Player && data[c].Player != tempDM[5].Player)
		{
		tempDM[6].Player = data[c].Player;
		tempDM[6].DMscore = data[c].DMscore;
		tempDM[6].DMdeaths = data[c].DMdeaths;
		s = data[c].DMscore;
		d = data[c].DMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDM[6] = data[c].Player$" - "$string(data[c].DMscore)$" - "$data[c].DMdeaths$" - "$int(Eff)$"%";
		}
	//check for DM #8
	else if ( data[c].DMscore >= tempDM[7].DMscore && data[c].Player != tempDM[0].Player && data[c].Player != tempDM[1].Player && data[c].Player != tempDM[2].Player && data[c].Player != tempDM[3].Player && data[c].Player != tempDM[4].Player && data[c].Player != tempDM[5].Player && data[c].Player != tempDM[6].Player)
		{
		tempDM[7].Player = data[c].Player;
		tempDM[7].DMscore = data[c].DMscore;
		tempDM[7].DMdeaths = data[c].DMdeaths;
		s = data[c].DMscore;
		d = data[c].DMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDM[7] = data[c].Player$" - "$string(data[c].DMscore)$" - "$data[c].DMdeaths$" - "$int(Eff)$"%";
		}
	//check for DM #9
	else if ( data[c].DMscore >= tempDM[8].DMscore && data[c].Player != tempDM[0].Player && data[c].Player != tempDM[1].Player && data[c].Player != tempDM[2].Player && data[c].Player != tempDM[3].Player && data[c].Player != tempDM[4].Player && data[c].Player != tempDM[5].Player && data[c].Player != tempDM[6].Player && data[c].Player != tempDM[7].Player)
		{
		tempDM[8].Player = data[c].Player;
		tempDM[8].DMscore = data[c].DMscore;
		tempDM[8].DMdeaths = data[c].DMdeaths;
		s = data[c].DMscore;
		d = data[c].DMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDM[8] = data[c].Player$" - "$string(data[c].DMscore)$" - "$data[c].DMdeaths$" - "$int(Eff)$"%";
		}
	//check for DM #10
	else if ( data[c].DMscore >= tempDM[9].DMscore && data[c].Player != tempDM[0].Player && data[c].Player != tempDM[1].Player && data[c].Player != tempDM[2].Player && data[c].Player != tempDM[3].Player && data[c].Player != tempDM[4].Player && data[c].Player != tempDM[5].Player && data[c].Player != tempDM[6].Player && data[c].Player != tempDM[7].Player && data[c].Player != tempDM[8].Player)
		{
		tempDM[9].Player = data[c].Player;
		tempDM[9].DMscore = data[c].DMscore;
		tempDM[9].DMdeaths = data[c].DMdeaths;
		s = data[c].DMscore;
		d = data[c].DMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDM[9] = data[c].Player$" - "$string(data[c].DMscore)$" - "$data[c].DMdeaths$" - "$int(Eff)$"%";
		}
}

//This function cycles through the TDM database and assign top 10 players
function CycleTDM()
{
local float Eff, s, d;

	//check for TDM #1
	if ( data[c].TDMscore >= tempTDM[0].TDMscore )
		{
		tempTDM[0].Player = data[c].Player;
		tempTDM[0].TDMscore = data[c].TDMscore;
		tempTDM[0].TDMdeaths = data[c].TDMdeaths;
		s = data[c].TDMscore;
		d = data[c].TDMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topTDM[0] = data[c].Player$" - "$string(data[c].TDMscore)$" - "$data[c].TDMdeaths$" - "$int(Eff)$"%";
		}
	//check for TDM #2
	else if ( data[c].TDMscore >= tempTDM[1].TDMscore && data[c].Player != tempTDM[0].Player )
		{
		tempTDM[1].Player = data[c].Player;
		tempTDM[1].TDMscore = data[c].TDMscore;
		tempTDM[1].TDMdeaths = data[c].TDMdeaths;
		s = data[c].TDMscore;
		d = data[c].TDMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topTDM[1] = data[c].Player$" - "$string(data[c].TDMscore)$" - "$data[c].TDMdeaths$" - "$int(Eff)$"%";
		}
	//check for TDM #3
	else if ( data[c].TDMscore >= tempTDM[2].TDMscore && data[c].Player != tempTDM[0].Player && data[c].Player != tempTDM[1].Player)
		{
		tempTDM[2].Player = data[c].Player;
		tempTDM[2].TDMscore = data[c].TDMscore;
		tempTDM[2].TDMdeaths = data[c].TDMdeaths;
		s = data[c].TDMscore;
		d = data[c].TDMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topTDM[2] = data[c].Player$" - "$string(data[c].TDMscore)$" - "$data[c].TDMdeaths$" - "$int(Eff)$"%";
		}
	//check for TDM #4
	else if ( data[c].TDMscore >= tempTDM[3].TDMscore && data[c].Player != tempTDM[0].Player && data[c].Player != tempTDM[1].Player && data[c].Player != tempTDM[2].Player)
		{
		tempTDM[3].Player = data[c].Player;
		tempTDM[3].TDMscore = data[c].TDMscore;
		tempTDM[3].TDMdeaths = data[c].TDMdeaths;
		s = data[c].TDMscore;
		d = data[c].TDMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topTDM[3] = data[c].Player$" - "$string(data[c].TDMscore)$" - "$data[c].TDMdeaths$" - "$int(Eff)$"%";
		}
	//check for TDM #5
	else if ( data[c].TDMscore >= tempTDM[4].TDMscore && data[c].Player != tempTDM[0].Player && data[c].Player != tempTDM[1].Player && data[c].Player != tempTDM[2].Player && data[c].Player != tempTDM[3].Player)
		{
		tempTDM[4].Player = data[c].Player;
		tempTDM[4].TDMscore = data[c].TDMscore;
		tempTDM[4].TDMdeaths = data[c].TDMdeaths;
		s = data[c].TDMscore;
		d = data[c].TDMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topTDM[4] = data[c].Player$" - "$string(data[c].TDMscore)$" - "$data[c].TDMdeaths$" - "$int(Eff)$"%";
		}	
	//check for TDM #6
	else if ( data[c].TDMscore >= tempTDM[5].TDMscore && data[c].Player != tempTDM[0].Player && data[c].Player != tempTDM[1].Player && data[c].Player != tempTDM[2].Player && data[c].Player != tempTDM[3].Player && data[c].Player != tempTDM[4].Player)
		{
		tempTDM[5].Player = data[c].Player;
		tempTDM[5].TDMscore = data[c].TDMscore;
		tempTDM[5].TDMdeaths = data[c].TDMdeaths;
		s = data[c].TDMscore;
		d = data[c].TDMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topTDM[5] = data[c].Player$" - "$string(data[c].TDMscore)$" - "$data[c].TDMdeaths$" - "$int(Eff)$"%";
		}	
	//check for TDM #7
	else if ( data[c].TDMscore >= tempTDM[6].TDMscore && data[c].Player != tempTDM[0].Player && data[c].Player != tempTDM[1].Player && data[c].Player != tempTDM[2].Player && data[c].Player != tempTDM[3].Player && data[c].Player != tempTDM[4].Player && data[c].Player != tempTDM[5].Player)
		{
		tempTDM[6].Player = data[c].Player;
		tempTDM[6].TDMscore = data[c].TDMscore;
		tempTDM[6].TDMdeaths = data[c].TDMdeaths;
		s = data[c].TDMscore;
		d = data[c].TDMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topTDM[6] = data[c].Player$" - "$string(data[c].TDMscore)$" - "$data[c].TDMdeaths$" - "$int(Eff)$"%";
		}
	//check for TDM #8
	else if ( data[c].TDMscore >= tempTDM[7].TDMscore && data[c].Player != tempTDM[0].Player && data[c].Player != tempTDM[1].Player && data[c].Player != tempTDM[2].Player && data[c].Player != tempTDM[3].Player && data[c].Player != tempTDM[4].Player && data[c].Player != tempTDM[5].Player && data[c].Player != tempTDM[6].Player)
		{
		tempTDM[7].Player = data[c].Player;
		tempTDM[7].TDMscore = data[c].TDMscore;
		tempTDM[7].TDMdeaths = data[c].TDMdeaths;
		s = data[c].TDMscore;
		d = data[c].TDMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topTDM[7] = data[c].Player$" - "$string(data[c].TDMscore)$" - "$data[c].TDMdeaths$" - "$int(Eff)$"%";
		}
	//check for TDM #9
	else if ( data[c].TDMscore >= tempTDM[8].TDMscore && data[c].Player != tempTDM[0].Player && data[c].Player != tempTDM[1].Player && data[c].Player != tempTDM[2].Player && data[c].Player != tempTDM[3].Player && data[c].Player != tempTDM[4].Player && data[c].Player != tempTDM[5].Player && data[c].Player != tempTDM[6].Player && data[c].Player != tempTDM[7].Player)
		{
		tempTDM[8].Player = data[c].Player;
		tempTDM[8].TDMscore = data[c].TDMscore;
		tempTDM[8].TDMdeaths = data[c].TDMdeaths;
		s = data[c].TDMscore;
		d = data[c].TDMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topTDM[8] = data[c].Player$" - "$string(data[c].TDMscore)$" - "$data[c].TDMdeaths$" - "$int(Eff)$"%";
		}
	//check for TDM #10
	else if ( data[c].TDMscore >= tempTDM[9].TDMscore && data[c].Player != tempTDM[0].Player && data[c].Player != tempTDM[1].Player && data[c].Player != tempTDM[2].Player && data[c].Player != tempTDM[3].Player && data[c].Player != tempTDM[4].Player && data[c].Player != tempTDM[5].Player && data[c].Player != tempTDM[6].Player && data[c].Player != tempTDM[7].Player && data[c].Player != tempTDM[8].Player)
		{
		tempTDM[9].Player = data[c].Player;
		tempTDM[9].TDMscore = data[c].TDMscore;
		tempTDM[9].TDMdeaths = data[c].TDMdeaths;
		s = data[c].TDMscore;
		d = data[c].TDMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topTDM[9] = data[c].Player$" - "$string(data[c].TDMscore)$" - "$data[c].TDMdeaths$" - "$int(Eff)$"%";
		}
}

//This function cycles through the CTF database and assign top 10 players
function CycleCTF()
{
local float Eff, s, d;

	//check for CTF #1
	if ( data[c].CTFscore >= tempCTF[0].CTFscore )
		{
		tempCTF[0].Player = data[c].Player;
		tempCTF[0].CTFscore = data[c].CTFscore;
		tempCTF[0].CTFdeaths = data[c].CTFdeaths;
		s = data[c].CTFscore;
		d = data[c].CTFdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topCTF[0] = data[c].Player$" - "$string(data[c].CTFscore)$" - "$data[c].CTFdeaths$" - "$int(Eff)$"%";
		}
	//check for CTF #2
	else if ( data[c].CTFscore >= tempCTF[1].CTFscore && data[c].Player != tempCTF[0].Player )
		{
		tempCTF[1].Player = data[c].Player;
		tempCTF[1].CTFscore = data[c].CTFscore;
		tempCTF[1].CTFdeaths = data[c].CTFdeaths;
		s = data[c].CTFscore;
		d = data[c].CTFdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topCTF[1] = data[c].Player$" - "$string(data[c].CTFscore)$" - "$data[c].CTFdeaths$" - "$int(Eff)$"%";
		}
	//check for CTF #3
	else if ( data[c].CTFscore >= tempCTF[2].CTFscore && data[c].Player != tempCTF[0].Player && data[c].Player != tempCTF[1].Player)
		{
		tempCTF[2].Player = data[c].Player;
		tempCTF[2].CTFscore = data[c].CTFscore;
		tempCTF[2].CTFdeaths = data[c].CTFdeaths;
		s = data[c].CTFscore;
		d = data[c].CTFdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topCTF[2] = data[c].Player$" - "$string(data[c].CTFscore)$" - "$data[c].CTFdeaths$" - "$int(Eff)$"%";
		}
	//check for CTF #4
	else if ( data[c].CTFscore >= tempCTF[3].CTFscore && data[c].Player != tempCTF[0].Player && data[c].Player != tempCTF[1].Player && data[c].Player != tempCTF[2].Player)
		{
		tempCTF[3].Player = data[c].Player;
		tempCTF[3].CTFscore = data[c].CTFscore;
		tempCTF[3].CTFdeaths = data[c].CTFdeaths;
		s = data[c].CTFscore;
		d = data[c].CTFdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topCTF[3] = data[c].Player$" - "$string(data[c].CTFscore)$" - "$data[c].CTFdeaths$" - "$int(Eff)$"%";
		}
	//check for CTF #5
	else if ( data[c].CTFscore >= tempCTF[4].CTFscore && data[c].Player != tempCTF[0].Player && data[c].Player != tempCTF[1].Player && data[c].Player != tempCTF[2].Player && data[c].Player != tempCTF[3].Player)
		{
		tempCTF[4].Player = data[c].Player;
		tempCTF[4].CTFscore = data[c].CTFscore;
		tempCTF[4].CTFdeaths = data[c].CTFdeaths;
		s = data[c].CTFscore;
		d = data[c].CTFdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topCTF[4] = data[c].Player$" - "$string(data[c].CTFscore)$" - "$data[c].CTFdeaths$" - "$int(Eff)$"%";
		}	
	//check for CTF #6
	else if ( data[c].CTFscore >= tempCTF[5].CTFscore && data[c].Player != tempCTF[0].Player && data[c].Player != tempCTF[1].Player && data[c].Player != tempCTF[2].Player && data[c].Player != tempCTF[3].Player && data[c].Player != tempCTF[4].Player)
		{
		tempCTF[5].Player = data[c].Player;
		tempCTF[5].CTFscore = data[c].CTFscore;
		tempCTF[5].CTFdeaths = data[c].CTFdeaths;
		s = data[c].CTFscore;
		d = data[c].CTFdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topCTF[5] = data[c].Player$" - "$string(data[c].CTFscore)$" - "$data[c].CTFdeaths$" - "$int(Eff)$"%";
		}	
	//check for CTF #7
	else if ( data[c].CTFscore >= tempCTF[6].CTFscore && data[c].Player != tempCTF[0].Player && data[c].Player != tempCTF[1].Player && data[c].Player != tempCTF[2].Player && data[c].Player != tempCTF[3].Player && data[c].Player != tempCTF[4].Player && data[c].Player != tempCTF[5].Player)
		{
		tempCTF[6].Player = data[c].Player;
		tempCTF[6].CTFscore = data[c].CTFscore;
		tempCTF[6].CTFdeaths = data[c].CTFdeaths;
		s = data[c].CTFscore;
		d = data[c].CTFdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topCTF[6] = data[c].Player$" - "$string(data[c].CTFscore)$" - "$data[c].CTFdeaths$" - "$int(Eff)$"%";
		}
	//check for CTF #8
	else if ( data[c].CTFscore >= tempCTF[7].CTFscore && data[c].Player != tempCTF[0].Player && data[c].Player != tempCTF[1].Player && data[c].Player != tempCTF[2].Player && data[c].Player != tempCTF[3].Player && data[c].Player != tempCTF[4].Player && data[c].Player != tempCTF[5].Player && data[c].Player != tempCTF[6].Player)
		{
		tempCTF[7].Player = data[c].Player;
		tempCTF[7].CTFscore = data[c].CTFscore;
		tempCTF[7].CTFdeaths = data[c].CTFdeaths;
		s = data[c].CTFscore;
		d = data[c].CTFdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topCTF[7] = data[c].Player$" - "$string(data[c].CTFscore)$" - "$data[c].CTFdeaths$" - "$int(Eff)$"%";
		}
	//check for CTF #9
	else if ( data[c].CTFscore >= tempCTF[8].CTFscore && data[c].Player != tempCTF[0].Player && data[c].Player != tempCTF[1].Player && data[c].Player != tempCTF[2].Player && data[c].Player != tempCTF[3].Player && data[c].Player != tempCTF[4].Player && data[c].Player != tempCTF[5].Player && data[c].Player != tempCTF[6].Player && data[c].Player != tempCTF[7].Player)
		{
		tempCTF[8].Player = data[c].Player;
		tempCTF[8].CTFscore = data[c].CTFscore;
		tempCTF[8].CTFdeaths = data[c].CTFdeaths;
		s = data[c].CTFscore;
		d = data[c].CTFdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topCTF[8] = data[c].Player$" - "$string(data[c].CTFscore)$" - "$data[c].CTFdeaths$" - "$int(Eff)$"%";
		}
	//check for CTF #10
	else if ( data[c].CTFscore >= tempCTF[9].CTFscore && data[c].Player != tempCTF[0].Player && data[c].Player != tempCTF[1].Player && data[c].Player != tempCTF[2].Player && data[c].Player != tempCTF[3].Player && data[c].Player != tempCTF[4].Player && data[c].Player != tempCTF[5].Player && data[c].Player != tempCTF[6].Player && data[c].Player != tempCTF[7].Player && data[c].Player != tempCTF[8].Player)
		{
		tempCTF[9].Player = data[c].Player;
		tempCTF[9].CTFscore = data[c].CTFscore;
		tempCTF[9].CTFdeaths = data[c].CTFdeaths;
		s = data[c].CTFscore;
		d = data[c].CTFdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topCTF[9] = data[c].Player$" - "$string(data[c].CTFscore)$" - "$data[c].CTFdeaths$" - "$int(Eff)$"%";
		}
}

//This function cycles through the DOM database and assign top 10 players
function CycleDOM()
{
local float Eff, s, d;

	//check for DOM #1
	if ( data[c].DOMscore >= tempDOM[0].DOMscore )
		{
		tempDOM[0].Player = data[c].Player;
		tempDOM[0].DOMscore = data[c].DOMscore;
		tempDOM[0].DOMdeaths = data[c].DOMdeaths;
		s = data[c].DOMscore;
		d = data[c].DOMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDOM[0] = data[c].Player$" - "$string(data[c].DOMscore)$" - "$data[c].DOMdeaths$" - "$int(Eff)$"%";
		}
	//check for DOM #2
	else if ( data[c].DOMscore >= tempDOM[1].DOMscore && data[c].Player != tempDOM[0].Player )
		{
		tempDOM[1].Player = data[c].Player;
		tempDOM[1].DOMscore = data[c].DOMscore;
		tempDOM[1].DOMdeaths = data[c].DOMdeaths;
		s = data[c].DOMscore;
		d = data[c].DOMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDOM[1] = data[c].Player$" - "$string(data[c].DOMscore)$" - "$data[c].DOMdeaths$" - "$int(Eff)$"%";
		}
	//check for DOM #3
	else if ( data[c].DOMscore >= tempDOM[2].DOMscore && data[c].Player != tempDOM[0].Player && data[c].Player != tempDOM[1].Player)
		{
		tempDOM[2].Player = data[c].Player;
		tempDOM[2].DOMscore = data[c].DOMscore;
		tempDOM[2].DOMdeaths = data[c].DOMdeaths;
		s = data[c].DOMscore;
		d = data[c].DOMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDOM[2] = data[c].Player$" - "$string(data[c].DOMscore)$" - "$data[c].DOMdeaths$" - "$int(Eff)$"%";
		}
	//check for DOM #4
	else if ( data[c].DOMscore >= tempDOM[3].DOMscore && data[c].Player != tempDOM[0].Player && data[c].Player != tempDOM[1].Player && data[c].Player != tempDOM[2].Player)
		{
		tempDOM[3].Player = data[c].Player;
		tempDOM[3].DOMscore = data[c].DOMscore;
		tempDOM[3].DOMdeaths = data[c].DOMdeaths;
		s = data[c].DOMscore;
		d = data[c].DOMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDOM[3] = data[c].Player$" - "$string(data[c].DOMscore)$" - "$data[c].DOMdeaths$" - "$int(Eff)$"%";
		}
	//check for DOM #5
	else if ( data[c].DOMscore >= tempDOM[4].DOMscore && data[c].Player != tempDOM[0].Player && data[c].Player != tempDOM[1].Player && data[c].Player != tempDOM[2].Player && data[c].Player != tempDOM[3].Player)
		{
		tempDOM[4].Player = data[c].Player;
		tempDOM[4].DOMscore = data[c].DOMscore;
		tempDOM[4].DOMdeaths = data[c].DOMdeaths;
		s = data[c].DOMscore;
		d = data[c].DOMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDOM[4] = data[c].Player$" - "$string(data[c].DOMscore)$" - "$data[c].DOMdeaths$" - "$int(Eff)$"%";
		}	
	//check for DOM #6
	else if ( data[c].DOMscore >= tempDOM[5].DOMscore && data[c].Player != tempDOM[0].Player && data[c].Player != tempDOM[1].Player && data[c].Player != tempDOM[2].Player && data[c].Player != tempDOM[3].Player && data[c].Player != tempDOM[4].Player)
		{
		tempDOM[5].Player = data[c].Player;
		tempDOM[5].DOMscore = data[c].DOMscore;
		tempDOM[5].DOMdeaths = data[c].DOMdeaths;
		s = data[c].DOMscore;
		d = data[c].DOMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDOM[5] = data[c].Player$" - "$string(data[c].DOMscore)$" - "$data[c].DOMdeaths$" - "$int(Eff)$"%";
		}	
	//check for DOM #7
	else if ( data[c].DOMscore >= tempDOM[6].DOMscore && data[c].Player != tempDOM[0].Player && data[c].Player != tempDOM[1].Player && data[c].Player != tempDOM[2].Player && data[c].Player != tempDOM[3].Player && data[c].Player != tempDOM[4].Player && data[c].Player != tempDOM[5].Player)
		{
		tempDOM[6].Player = data[c].Player;
		tempDOM[6].DOMscore = data[c].DOMscore;
		tempDOM[6].DOMdeaths = data[c].DOMdeaths;
		s = data[c].DOMscore;
		d = data[c].DOMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDOM[6] = data[c].Player$" - "$string(data[c].DOMscore)$" - "$data[c].DOMdeaths$" - "$int(Eff)$"%";
		}
	//check for DOM #8
	else if ( data[c].DOMscore >= tempDOM[7].DOMscore && data[c].Player != tempDOM[0].Player && data[c].Player != tempDOM[1].Player && data[c].Player != tempDOM[2].Player && data[c].Player != tempDOM[3].Player && data[c].Player != tempDOM[4].Player && data[c].Player != tempDOM[5].Player && data[c].Player != tempDOM[6].Player)
		{
		tempDOM[7].Player = data[c].Player;
		tempDOM[7].DOMscore = data[c].DOMscore;
		tempDOM[7].DOMdeaths = data[c].DOMdeaths;
		s = data[c].DOMscore;
		d = data[c].DOMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDOM[7] = data[c].Player$" - "$string(data[c].DOMscore)$" - "$data[c].DOMdeaths$" - "$int(Eff)$"%";
		}
	//check for DOM #9
	else if ( data[c].DOMscore >= tempDOM[8].DOMscore && data[c].Player != tempDOM[0].Player && data[c].Player != tempDOM[1].Player && data[c].Player != tempDOM[2].Player && data[c].Player != tempDOM[3].Player && data[c].Player != tempDOM[4].Player && data[c].Player != tempDOM[5].Player && data[c].Player != tempDOM[6].Player && data[c].Player != tempDOM[7].Player)
		{
		tempDOM[8].Player = data[c].Player;
		tempDOM[8].DOMscore = data[c].DOMscore;
		tempDOM[8].DOMdeaths = data[c].DOMdeaths;
		s = data[c].DOMscore;
		d = data[c].DOMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDOM[8] = data[c].Player$" - "$string(data[c].DOMscore)$" - "$data[c].DOMdeaths$" - "$int(Eff)$"%";
		}
	//check for DOM #10
	else if ( data[c].DOMscore >= tempDOM[9].DOMscore && data[c].Player != tempDOM[0].Player && data[c].Player != tempDOM[1].Player && data[c].Player != tempDOM[2].Player && data[c].Player != tempDOM[3].Player && data[c].Player != tempDOM[4].Player && data[c].Player != tempDOM[5].Player && data[c].Player != tempDOM[6].Player && data[c].Player != tempDOM[7].Player && data[c].Player != tempDOM[8].Player)
		{
		tempDOM[9].Player = data[c].Player;
		tempDOM[9].DOMscore = data[c].DOMscore;
		tempDOM[9].DOMdeaths = data[c].DOMdeaths;
		s = data[c].DOMscore;
		d = data[c].DOMdeaths;
		Eff = s / (s + d) * 100;
		if ( Eff < 0 )
			Eff = 0;
		topDOM[9] = data[c].Player$" - "$string(data[c].DOMscore)$" - "$data[c].DOMdeaths$" - "$int(Eff)$"%";
		}
}
				
function AssignTopStats(PlayerPawn P)
{
local PRI PI;

	PI = PRI(P.PlayerReplicationInfo);
	
	PI.dm1 = topDM[0];
	PI.dm2 = topDM[1];
	PI.dm3 = topDM[2];
	PI.dm4 = topDM[3];
	PI.dm5 = topDM[4];
	PI.dm6 = topDM[5];
	PI.dm7 = topDM[6];
	PI.dm8 = topDM[7];
	PI.dm9 = topDM[8];
	PI.dm10 = topDM[9];
	
	PI.tdm1 = topTDM[0];
	PI.tdm2 = topTDM[1];
	PI.tdm3 = topTDM[2];
	PI.tdm4 = topTDM[3];
	PI.tdm5 = topTDM[4];
	PI.tdm6 = topTDM[5];
	PI.tdm7 = topTDM[6];
	PI.tdm8 = topTDM[7];
	PI.tdm9 = topTDM[8];
	PI.tdm10 = topTDM[9];
	
	PI.ctf1 = topCTF[0];
	PI.ctf2 = topCTF[1];
	PI.ctf3 = topCTF[2];
	PI.ctf4 = topCTF[3];
	PI.ctf5 = topCTF[4];
	PI.ctf6 = topCTF[5];
	PI.ctf7 = topCTF[6];
	PI.ctf8 = topCTF[7];
	PI.ctf9 = topCTF[8];
	PI.ctf10 = topCTF[9];
	
	PI.dom1 = topDOM[0];
	PI.dom2 = topDOM[1];
	PI.dom3 = topDOM[2];
	PI.dom4 = topDOM[3];
	PI.dom5 = topDOM[4];
	PI.dom6 = topDOM[5];
	PI.dom7 = topDOM[6];
	PI.dom8 = topDOM[7];
	PI.dom9 = topDOM[8];
	PI.dom10 = topDOM[9];
	
	PI.Map1 = topMaps[0];
	PI.Map2 = topMaps[1];
	PI.Map3 = topMaps[2];
	PI.Map4 = topMaps[3];
	PI.Map5 = topMaps[4];
	PI.Map6 = topMaps[5];
	PI.Map7 = topMaps[6];
	PI.Map8 = topMaps[7];
	PI.Map9 = topMaps[8];
	PI.Map10 = topMaps[9];
	
	TimeBetweenStatAssign = 10;
}						
	
function Timer()
{
local PlayerPawn P;

	if ( TimeBetweenStatAssign <= 0 )
		{
		ForEach AllActors(class'PlayerPawn', P )
			{
			AssignTopStats(P);
			}
		}
	else
		TimeBetweenStatAssign--;
		
	if ( !MapAssignedToDB && countdown > 0 )
		countdown--;
	else if ( !MapAssignedToDB && countdown <= 0 )
		AddMapToDatabase();
		
}

function ScoreKill(Pawn Killer, Pawn Other)
{
local PlayerPawn P;
local int i;

	//log("xSetup Statistic module:"@Killer.PlayerReplicationInfo.PlayerName$" killed:"@Other.PlayerReplicationInfo.PlayerName);

	ForEach AllActors(class'PlayerPawn', P )
		{
		if ( P == Killer || P == Other )
			{
			for ( i=0; i<32; i++ )
				{
				if (( P.PlayerReplicationInfo.PlayerName == db[i].Player ) || ( db[i].Player == "" ))
					{
					db[i].Player = P.PlayerReplicationInfo.PlayerName;
					if ( P == Killer )
						{
						if ( gamestyle == "DM" )
							db[i].DMscore += 1;
						else if ( gamestyle == "TDM" )
							db[i].TDMscore += 1;
						else if ( gamestyle == "CTF" )
							db[i].CTFscore += 1;
						else if ( gamestyle == "DOM" )
							db[i].DOMscore += 1;
						//log ("xSetup Statistic module: frag logged for:"@P.PlayerReplicationInfo.PlayerName);
						}
					if ( P == Other )
						{
						if ( gamestyle == "DM" )
							db[i].DMdeaths += 1;
						else if ( gamestyle == "TDM" )
							db[i].TDMdeaths += 1;
						else if ( gamestyle == "CTF" )
							db[i].CTFdeaths += 1;
						else if ( gamestyle == "DOM" )
							db[i].DOMdeaths += 1;
						//log ("xSetup Statistic module: death logged for:"@P.PlayerReplicationInfo.PlayerName);
						}
					i = 20000;
					}
				}
			}
		}
}

function bool HandleEndGame()
{
local int i, ii;

	for ( i=0;i<32;i++ )
		{
		if ( db[i].Player != "" )
			{
			for ( ii=0;ii<10000;ii++)
				{
				if ( data[ii].Player == db[i].Player || data[ii].Player == "" )
					{
					data[ii].Player = db[i].Player;
					data[ii].DMscore += db[i].DMscore;
					data[ii].TDMscore += db[i].TDMscore;
					data[ii].CTFscore += db[i].CTFscore;
					data[ii].DOMscore += db[i].DOMscore;
					data[ii].DMdeaths += db[i].DMdeaths;
					data[ii].TDMdeaths += db[i].TDMdeaths;
					data[ii].CTFdeaths += db[i].CTFdeaths;
					data[ii].DOMdeaths += db[i].DOMdeaths;
					ii = 50000;
					}
				}
			}
		}
	SaveConfig();
		
}

defaultproperties
{
countdown=5
MapAssignedToDB=False
}
